// jQuery for page scrolling feature - requires jQuery Easing plugin
$(function() {
    $('a.page-scroll').bind('click', function(event) {
        var $anchor = $(this);
        $('html, body').stop().animate({
            scrollTop: $($anchor.attr('href')).offset().top
        }, 1500, 'easeInOutExpo');
        event.preventDefault();
    });
    
 
});

$(window).scroll(function () {
    if ($(this).scrollTop() > 500) {
        $('.scrollup').fadeIn();
    } else {
        $('.scrollup').fadeOut();
    }
});

$('.scrollup').click(function () {
    $("html, body").animate({
        scrollTop: 0
    }, 600);
    return false;
});

$('.scrollup').hide();

// Highlight the top nav as scrolling occurs
$('body').scrollspy({
    target: '.navbar-fixed-top'
});

$("#closeTransporte").click(function(){
	$("#divTransporte").hide();
	$("#ayudaTransporte").css('visibility', 'visible');
});

$("#ayudaTransporte").click(function(){
	$("#divTransporte").show();
	$("#ayudaTransporte").css('visibility', 'hidden');
});

$("#closeCarga").click(function(){
	$("#divCarga").hide();
	$("#ayudaCarga").css('visibility', 'visible');
});

$("#ayudaCarga").click(function(){
	$("#divCarga").show();
	$("#ayudaCarga").css('visibility', 'hidden');
});

function cambiarIdioma(idioma){
	document.location = setUrlNoCache($.rup.CTX_PATH + 'calculador/inicio?locale='+idioma);
}

var transporteObj = new Object();
var transporteObjSol = new Object();
var listaBobinas = new Array();
var posBobina = 0;
var densidadParam = -1;
var primerVehiculo = true;
var primerTipoSujecion = true;
var primerMaterial = true;
var paddingTop;
var fontSize;
var mostrarGraficos = true;
function seleccionaVehiculo(pos){	
	$( "[id*='selVehiculo']").removeClass("pulsado colorSeleccionado");
	$( "[id*='seleccionaVehiculoSpan']").removeClass("a-btn-icon-right-sel");	
	$("#seleccionaVehiculoSpan"+pos).addClass("a-btn-icon-right-sel");	
	$("#selVehiculo"+pos).addClass("pulsado colorSeleccionado");
	transporteObj.vehiculo = new Object();
	transporteObj.vehiculo.codigo = pos;
	
	if (primerVehiculo){
		primerVehiculo = false;
		setTimeout(function(){ 
			$('a[href$="tipoSujecion"]').click();
		}, 300);
	}
}

function compruebaCambioTipoSujeccion(pos){
	var  cambio=false;
	if(transporteObj.tipoSujecion != undefined && transporteObj.tipoSujecion != "" && listaBobinas.length>0){
	var codsujecion= pos;
	var sujecionSeleccionada = new Object();
	for(k = 0; k < arrayTipoSujeccion.length; k++){
		if(codsujecion == arrayTipoSujeccion[k].codigo){
			sujecionSeleccionada = arrayTipoSujeccion[k];
			break;
		}
	}		
	var isFleje = (sujecionSeleccionada.tipo == FLEJE)?true:false;
	var sujanterior=transporteObj.tipoSujecion.codigo;
	var  sujecionAnterior = new Object();
	for(k = 0; k < arrayTipoSujeccion.length; k++){
		if(sujanterior == arrayTipoSujeccion[k].codigo){
			sujecionAnterior = arrayTipoSujeccion[k];
			break;
		}
	}
	var isBobina = (sujecionAnterior.tipo == BOBINA)?true:false;
	
	if(isBobina==true && isFleje==true || isBobina==false && isFleje==false){
		cambio=true;
}
	
}
	return cambio;
	
}

function marcandoTSujecion(pos){
	$( "[id*='selTipoSujecion']").removeClass("pulsado colorSeleccionado");
	$( "[id*='seleccionaTipoSujecionSpan']").removeClass("a-btn-icon-right-sel");	
	$("#seleccionaTipoSujecionSpan"+pos).addClass("a-btn-icon-right-sel");	
	$("#selTipoSujecion"+pos).addClass("pulsado colorSeleccionado");
	if (primerTipoSujecion){
		primerTipoSujecion = false;
		setTimeout(function(){ 
			$('a[href$="tipoDensidad"]').click();
		}, 300);
	}
}

function seleccionaTipoSujecion(pos){
	if(compruebaCambioTipoSujeccion(pos)){
		confirmarCambio(pos);
	}else{
		marcandoTSujecion(pos);
		transporteObj.tipoSujecion = new Object();
		transporteObj.tipoSujecion.codigo = pos ;
	}

}



function seleccionaDensidad(pos){

	$( "[id*='selDensidad']").removeClass("pulsado colorSeleccionado");
	$( "[id*='seleccionaDensidadSpan']").removeClass("a-btn-icon-right-sel");	
	$("#seleccionaDensidadSpan"+pos).addClass("a-btn-icon-right-sel");	
	$("#selDensidad"+pos).addClass("pulsado colorSeleccionado");
	densidadParam = pos;
	
	if (primerMaterial){
		primerMaterial = false;
		setTimeout(function(){ 
			document.getElementById("datosCarga").scrollIntoView();
		}, 300);

	}
	//pesoEstimado();
}

function formatoTablaGrafico(){
	$("#estibaGrafico").removeClass("oculto");
	$("#ubicacionGrafico").removeClass("oculto");
	$("#estibaTablaGrafico").removeClass("oculto");	
	$("#estibaTabla").addClass("oculto");
	mostrarGraficos = true;
}

function formatoTabla(){
	$("#estibaGrafico").addClass("oculto");
	$("#ubicacionGrafico").addClass("oculto");
	$("#estibaTablaGrafico").addClass("oculto");	
	$("#estibaTabla").removeClass("oculto");
	mostrarGraficos = false;
}

function eliminarFila(pos){
	$("#row_" + pos).remove();	
	for(z=0;z<listaBobinas.length;z++){
		if (pos == listaBobinas[z].id){
			listaBobinas.splice(z,1);
			break;
		}
	}
	borrarSolucion();
}

setUrlNoCache = function(url) {
	var noCache = new Date().getTime();
	var and = '?';
	if(url.indexOf('?') >= 0){
		and = '&';
	}
	url+= and + '_=' +noCache;
	url+='&'+PORTALWAR;	
	return url;
};



messageFormatter = function(source, params) {
	if (arguments.length > 2 && params.constructor != Array) {
		params = $.makeArray(arguments).slice(1);
	}
	if (params.constructor != Array) {
		params = [params];
	}
	$.each(params, function(i, n) {
		source = source.replace(new RegExp("\\{" + i + "\\}", "g"), n);
	});
	return source;
};

function validaTransporte(){
	var validacion = true;
	var texto = pintaCapaErrorInicio();	
	//Validar Vehiculo, tipo sujecion y al menos una bobina
	if(transporteObj.vehiculo == undefined || transporteObj.vehiculo==""){
		texto = texto + pintaError($.rup.i18n.app.validartransporte.vehiculo);	
		validacion = false;
	}
	if(transporteObj.tipoSujecion == undefined || transporteObj.tipoSujecion==""){
		texto = texto + pintaError($.rup.i18n.app.validartransporte.tiposujecion);	
		validacion = false;
	}
	if(listaBobinas == undefined || listaBobinas.length == 0){
		texto = texto + pintaError($.rup.i18n.app.validartransporte.bobina);	
		validacion = false;
	}	
	if(validacion == false){
		texto = texto + pintaCapaErrorFin();
		$('#mensajeErrores').html(texto);
		document.getElementById('mensajeErrores').style.display='block';
	}
	return validacion;
}

function realizarCalculo(){
	if(validaTransporte()){
		var transporte = serializeTransporte();
		calcular($.rup.CTX_PATH + "calculador/simular", transporte);
		$('#mensajeErrores').html("");
		document.getElementById('mensajeErrores').style.display='none';
		$(".thumb").addClass("redimension");
	} else {
		$("#introduccionDatos").addClass("col-md-12");
		$("#introduccionDatos").removeClass("col-md-7");
		$("#presentacionResultado").removeClass("col-md-5");
		document.getElementById('presentacionResultado').style.display='none';
	}
}
function serializeTransporte() {
	transporteObj.bobinas = listaBobinas; 
	//Anyadir Bobinas
	return transporteObj;
}

function visualizarSolucion(resultado){
	//pintamos solucion
	if(resultado.ubicaciones && resultado.ubicaciones.length > 0){
		var texto = '';
		var peso = '';
		for(i = 0; i< resultado.ubicaciones.length; i++){
			peso = resultado.ubicaciones[i].peso.toString();
			peso = peso.replace('.',',');
			texto = texto +  '<tr"><td class="text-center">'+resultado.ubicaciones[i].posicion.identificacion+'</td>'+
		    '<td class="text-right">'+resultado.ubicaciones[i].anchura+'</td>'+
			'<td class="text-right">'+resultado.ubicaciones[i].diametroExt+'</td>'+
			'<td class="text-right">'+ peso +'</td>'+
			'<td class="text-right">'+resultado.ubicaciones[i].posicion.distancia+'</td>'+
		   '</tr>';
		}
		$('#tablasol tbody').html(texto);
	}
	if(resultado.solucion && resultado.solucion.grafico){
			$('#graficosol').html('<img class="img-rounded img-responsive" src="'+$.rup.STATICS+'/aa94a/images/'+resultado.solucion.grafico +'" alt="">');	
	}
	if(resultado.solucion && resultado.solucion.tipoDistancia){
		var desc = (idiomaNav == idiomaEu)?resultado.solucion.tipoDistancia.descEu:resultado.solucion.tipoDistancia.descEs;		
		$('#distanciasol').html(desc);	
	}
	if(resultado.solucion && resultado.solucion.estibas && resultado.solucion.estibas.length > 0){
		var texto = '';
		var texto2='';
		for(j = 0; j< resultado.solucion.estibas.length; j++){	
			var desc = (idiomaNav == idiomaEu)?resultado.solucion.estibas[j].descEu:resultado.solucion.estibas[j].descEs;
			var imagen = (idiomaNav == idiomaEu)?resultado.solucion.estibas[j].imagenEu:resultado.solucion.estibas[j].imagenEs;
			texto = texto + '<tr><td class="text-left estibas">'+desc+'</td><td class="text-center"><img class="img-rounded img-responsive" src="'+$.rup.STATICS+'/aa94a/images/'+imagen+'"/></td></tr>';			
			texto2= texto2 + '<tr><td class="text-left">'+desc+'</td></tr>';			
		}
		$('#estibasol tbody').html(texto);
		$('#estibasol2 tbody').html(texto2);
	}	
	$("#introduccionDatos").removeClass("col-md-12");
	$("#introduccionDatos").addClass("col-md-7");
	$("#presentacionResultado").addClass("col-md-5");
	document.getElementById('presentacionResultado').style.display='block';
	document.location.href="#presentacionResultado";
	transporteObjSol=transporteObj;
	
	paddingTop = $(".a-btn-text").css("padding-top");
	$(".a-btn-text").css("padding-top", "10px");
	fontSize = $(".a-btn-text").css("font-size");
	if ($( window ).width() >= 1000 && $( window ).width() <= 1200){
		$(".a-btn-text").css("font-size", "13.5px");
	}
}

pintaCapaErrorInicio = function (){
	var texto = '<div class="alert alert-danger">';
	texto = texto + '<a href="#" class="close" data-dismiss="alert"	aria-label="close">&times;</a>';
	texto = texto + '<ul> <b>' + $.rup.i18n.app.aa94a_mensajes.error_producido + '</b>';
	return texto;

};
pintaError = function (mensaje){
	var texto = '<li>'+mensaje+'</li>';
	return texto;
};
pintaCapaErrorFin = function (){
	var texto = '</ul></div>';
	return texto;
};

function visualizarError(resultado){
	//pintamos Error		
	if(resultado.mensajes && resultado.mensajes.length > 0){
		var texto = pintaCapaErrorInicio();		
		for(z = 0; z< resultado.mensajes.length; z++){	
			var desc = (idiomaNav == idiomaEu)?resultado.mensajes[z].descEu:resultado.mensajes[z].descEs;
			texto = texto + pintaError(desc);			
		}
		texto = texto + pintaCapaErrorFin();
		$('#mensajeErrores').html(texto);
		document.getElementById('mensajeErrores').style.display='block';
	}	
}

function calcular(url, transporte) {	
	url = setUrlNoCache(url);
	$.ajax({
		url : url,
		type : "POST",
		data : JSON.stringify(transporte),
		contentType : "application/json",
		success : function(xhr, ajaxOptions) {
			var resultado = $.parseJSON(xhr);
			if(resultado.haySolucion){
				visualizarSolucion(resultado);
				//document.getElementById('mensajeErrores').style.display='none';
			}else{
				visualizarError(resultado);
				//document.getElementById('presentacionResultado').style.display='none';
			}	
			formatoTablaGrafico();
		},
		error : function(error) {
			desBloquearInterfaz();
		},
		beforeSend : function() {
			bloquearInterfaz();
		},
		complete : function() {	
			desBloquearInterfaz();
		}
	});

}


function calcularPesoEstimado(url, bobina) {	
	url = setUrlNoCache(url);
	$.ajax({
		url : url,
		type : "POST",
		data : JSON.stringify(bobina),
		contentType : "application/json",
		success : function(xhr, ajaxOptions) {
			var resultado = $.parseJSON(xhr);
			//Pintar resultado
			if(resultado != ''){
				var texto = pintaPesoEstimado(resultado);
				$('#pesoestimado').html(texto);
				$('#peso').val(resultado.replace(',', '.'));
			}	
			
		},
		error : function(error) {
			desBloquearInterfaz();
		},
		beforeSend : function() {
			bloquearInterfaz();
		},
		complete : function() {	
			desBloquearInterfaz();
		}
	});

}

pintaPesoEstimado = function (peso){
	var texto = '<div class="alert alert-success">';
	texto = texto + '<a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>';
	texto = texto + messageFormatter($.rup.i18n.app.aa94a_mensajes.peso_estimado,peso);
	texto = texto + '</div>';
	return texto;
};

function pesoEstimado(){
	if(validaBobina(false, false)){
		var bobina = dameBobina();
		bobina.peso=bobina.peso.replace(",",".");
		calcularPesoEstimado($.rup.CTX_PATH + "calculador/pesoEstimado", bobina);
	}
}


function validaBobina(pesoEstimado, validaPeso){
	// Borrar mensaje de error
	$('#mensajeErrores').html('');
	var texto = pintaCapaErrorInicio();	
	var bobina = dameBobina();
	var validacion = true;
	var validacionesPrevias = true;
	
	if(transporteObj == undefined || transporteObj.tipoSujecion == undefined || transporteObj.tipoSujecion == ""){
		texto = texto + pintaError($.rup.i18n.app.validartransporte.tiposujecion);	
		validacion = false;
		validacionesPrevias = false;
	}
	if (validaPeso == false && densidadParam == -1){
		texto = texto + pintaError($.rup.i18n.app.validarbobina.material);	
		validacion = false;
		validacionesPrevias = false;
	}
	if(validacionesPrevias){
		var codsujecion= transporteObj.tipoSujecion.codigo;
		var sujecionSeleccionada = new Object();
		for(k = 0; k < arrayTipoSujeccion.length; k++){
			if(codsujecion == arrayTipoSujeccion[k].codigo){
				sujecionSeleccionada = arrayTipoSujeccion[k];
				break;
			}
		}
		var isFleje = (sujecionSeleccionada.tipo == FLEJE)?true:false;
		var cargaCondiciones = (sujecionSeleccionada.tipo == FLEJE)?flejeJson:bobinaJson;
		var ANCHURA_MIN = cargaCondiciones.anchuraMin;
		var ANCHURA_MAX = cargaCondiciones.anchuraMax;
		var PESO_MIN = cargaCondiciones.pesoMin;
		var PESO_MAX = cargaCondiciones.pesoMax;
		var DIAMETRO_EXT_MIN = cargaCondiciones.diametroExtMin;
		var DIAMETRO_EXT_MAX = cargaCondiciones.diametroExtMax;
		var DIAMETRO_INT_MIN = cargaCondiciones.diametroIntMin;
		var DIAMETRO_INT_MAX = cargaCondiciones.diametroIntMax;
		var RELACION_ANCHURA_DIAM_EXT = cargaCondiciones.relacionAnchuraDiametroExt;
		var diametroExtCorrecto = false;
		//VALIDANDO DIAMETRO EXTERIOR
		var diametroExtOk=false;
		if(bobina.diametroExt == undefined || bobina.diametroExt == ""){
			texto = texto + pintaError($.rup.i18n.app.validarbobina.dexterior);		
			validacion = false;
		}else{		
			if (isImporteValido(bobina.diametroExt, 4, 0)) {diametroExtOk=true;
				if(bobina.diametroExt<=DIAMETRO_EXT_MIN || bobina.diametroExt>DIAMETRO_EXT_MAX){
					var array = new Array();
					array.push(DIAMETRO_EXT_MIN);
					array.push(DIAMETRO_EXT_MAX);
					texto = texto + pintaError(messageFormatter($.rup.i18n.app.validarbobina.deincorrecto, array));
					validacion = false;
			    } else {
			    	diametroExtCorrecto = true;
			    }
			}else{
				texto = texto + pintaError($.rup.i18n.app.validarbobina.deentero);
		    	validacion = false;
		    }
			
				
			
		}
		
		//VALIDANDO ANCHURA
		if(bobina.anchura == undefined || bobina.anchura == ""){		
			texto = texto + pintaError($.rup.i18n.app.validarbobina.anchura);
			validacion = false;
		}else{
			if (isImporteValido(bobina.anchura, 4, 0)) {
				// Cuando es fleje y tiene diametro ext valido
				if (isFleje && diametroExtCorrecto){
					// Comprobamos que se cumple la relacion entre anchura y diametro
					if (redondearImporte(bobina.anchura, bobina.diametroExt) > RELACION_ANCHURA_DIAM_EXT) {
						// Si validacion no es correcta
						diametroExtCorrecto = false;	
					}
				}
				if((isFleje && !diametroExtCorrecto) || bobina.anchura <= ANCHURA_MIN || bobina.anchura>ANCHURA_MAX){	
					var array = new Array();
					if (isFleje && !diametroExtCorrecto){
						// Poner mensaje de error especifico del fleje y la relacion
						array.push(RELACION_ANCHURA_DIAM_EXT);
						texto = texto + pintaError(messageFormatter($.rup.i18n.app.validarbobina.relAnchuraDiametro, array));
						validacion = false;
					} else if (bobina.anchura <= ANCHURA_MIN || bobina.anchura>ANCHURA_MAX){
						array.push(ANCHURA_MIN);
						array.push(ANCHURA_MAX);
						texto = texto + pintaError(messageFormatter($.rup.i18n.app.validarbobina.abincorrecta, array));
						validacion = false;
					}
				}
			}else{
				texto = texto + pintaError($.rup.i18n.app.validarbobina.aentero);
				validacion = false;
		    }		
		}
		
		

		//VALIDANDO DIAMETRO INTERIOR
		var diametroIntOk=false;
		if (validaPeso == false){
			if(bobina.diametroInt == undefined || bobina.diametroInt == ""){
				texto = texto + pintaError($.rup.i18n.app.validarbobina.diinterior);
		    	validacion = false;
			}else{
				if (isImporteValido(bobina.diametroInt, 4, 0)) {diametroIntOk=true;
					if(bobina.diametroInt<=DIAMETRO_INT_MIN || bobina.diametroInt>DIAMETRO_INT_MAX){	
						var array = new Array();
						array.push(DIAMETRO_INT_MIN);
						array.push(DIAMETRO_INT_MAX);
						texto = texto + pintaError(messageFormatter($.rup.i18n.app.validarbobina.diincorrecto, array));
						validacion = false;
				    }
								
				}
			    else{
			    	texto = texto + pintaError($.rup.i18n.app.validarbobina.dientero);
			    	validacion = false;
			    }
			}
		}
		
		if(diametroExtOk==true && diametroIntOk==true){
			if(parseFloat(bobina.diametroExt)<=parseFloat(bobina.diametroInt)){
				texto = texto + pintaError($.rup.i18n.app.validarbobina.dextmayordint);
		    	validacion = false;
			}
		}
		
		
		//VALIDANDO PESO
		if(pesoEstimado == false && validaPeso == true){
			if(bobina.peso == undefined || bobina.peso == ""){			
				texto = texto + pintaError($.rup.i18n.app.validarbobina.peso);
		    	validacion = false;
			}else{
				if (isImporteValido(bobina.peso, 3, 4)) {
					if(bobina.peso<=PESO_MIN || bobina.peso>PESO_MAX){		
						var array = new Array();
						array.push(PESO_MIN);
						array.push(PESO_MAX);
						texto = texto + pintaError(messageFormatter($.rup.i18n.app.validarbobina.pincorrecto, array));
						validacion = false;
				    }
			    }else{		
			    	texto = texto + pintaError($.rup.i18n.app.validarbobina.pentero);
			    	validacion = false;
			    }
			}

			//VALIDANDO DENSIDAD
			if (validaPeso == false){
				if(bobina.densidad == undefined ||  bobina.densidad.codigo == undefined || bobina.densidad.codigo == -1){	
					texto = texto + pintaError($.rup.i18n.app.validarbobina.material);
			    	validacion = false;
				}
			}
		}/*else{
			texto = texto + pintaError($.rup.i18n.app.validarbobina.sujecion);
			validacion = false;	
		}*/
	}

	if(pesoEstimado == false && validacion == false){
		texto = texto + pintaCapaErrorFin();		
		$('#mensajeErrores').html(texto);
		document.getElementById('mensajeErrores').style.display='block';
	}	
	return validacion;
}

function dameBobina(){
	var bobina = new Object();
	bobina.id = posBobina;
	bobina.anchura = document.getElementById("anchura").value;
 	bobina.diametroExt=document.getElementById("dexterior").value;
 	bobina.diametroInt=document.getElementById("dinterior").value;
  	bobina.peso=document.getElementById("peso").value.replace('.',',');
 	bobina.densidad= new Object();
 	bobina.densidad.codigo= densidadParam;
   	return bobina;
}


isImporteValido = function(valor, lengthEntero, lengthDecimal){
	
	lengthEntero = lengthEntero && lengthEntero != "" && lengthEntero > 0 ? lengthEntero : 10;
	lengthDecimal = lengthDecimal && lengthDecimal != "" && lengthDecimal > -1 ? lengthDecimal : 2;
	
	var numEnteroMax = Math.pow(10,lengthEntero)-1;
	var numDecimalMax = Math.pow(10,lengthDecimal)-1;
	
	if (valor == ''){
		return true;
	} else {
		if (valor.indexOf(' ') != -1) {
			return false;
		}
		if(valor.indexOf(',') != -1){
			//tiene parte decimal
			var partes = valor.split(',');
			if(partes.length > 2){
				return false;
			}else if (partes.length == 1){
				return (!isNaN(partes[0]));
			}else if (partes.length == 2){
				var parteEntera = partes[0].replace('.', '');
				var parteDecimal = partes[1];
				if((isNaN(parteEntera)) || parteEntera > numEnteroMax || (isNaN(parteDecimal)) || parteDecimal == '' || (parteDecimal != '' && parseInt(parteDecimal)>numDecimalMax)){
					return false;
				}else{
					return true;
				}
			}
		}else{
			var parteEntera = valor.replace('.', '');
			return (!isNaN(parteEntera) && parteEntera < numEnteroMax );
		}
	}
	return true;
};


function addBobina(){
	if(validaBobina(false, true)){
		var bobina = dameBobina();
		 	//ACTUALIZA TABLA	 	
		 	$('#tablaBobinas tbody').append('<tr id="row_' + bobina.id + '"><td class="text-center">' + bobina.anchura + '</td>'+
				    '<td class="text-center">'+bobina.diametroExt+'</td>'+
					'<td class="text-center">'+bobina.peso+'</td>'+
					'<td class="text-center">'+											  
					'<a onclick="eliminarFila('+bobina.id+')" class="btn btn-link btn-md" data-toggle="tooltip" role="button" title="'+$.rup.i18n.base.rup_maint["delete"] + '">'+
					$.rup.i18n.base.rup_maint["delete"] + '</a>'+											
					'</td>'+
				   '</tr>');
		 	bobina.peso=bobina.peso.replace(",",".");
			listaBobinas.push(bobina);			
		 	posBobina = posBobina + 1;
		 	document.getElementById('mensajeErrores').style.display='none';
		 	document.getElementById("anchura").value="";
		 	document.getElementById("dexterior").value="";
		 	document.getElementById("dinterior").value="";
		 	document.getElementById("peso").value="";
			$('#pesoestimado').html('');
			borrarSolucion();
	} 
}

function borrarSolucion(){
	$("#introduccionDatos").removeClass("col-md-7");
	$("#introduccionDatos").addClass("col-md-12");
	$("#presentacionResultado").removeClass("col-md-5");
	document.getElementById('presentacionResultado').style.display='none';
	transporteObjSol = new Object();
}


function limpiar(){
	$("#introduccionDatos").removeClass("col-md-7");
	$("#introduccionDatos").addClass("col-md-12");
	$("#presentacionResultado").removeClass("col-md-5");
	document.getElementById('presentacionResultado').style.display='none';
	$("[id*='row_']").remove();
	$('#mensajeErrores').removeClass('alert alert-danger');
	$('#mensajeErrores').html("");
	$( "[id*='selVehiculo']").removeClass("pulsado colorSeleccionado");
	$( "[id*='seleccionaVehiculoSpan']").removeClass("a-btn-icon-right-sel");
	$( "[id*='selTipoSujecion']").removeClass("pulsado colorSeleccionado");
	$( "[id*='seleccionaTipoSujecionSpan']").removeClass("a-btn-icon-right-sel");
	document.getElementById("anchura").value="";
	document.getElementById("dexterior").value="";
	document.getElementById("dinterior").value="";
	document.getElementById("peso").value="";
	$( "[id*='selDensidad']").removeClass("pulsado colorSeleccionado");
	$( "[id*='seleccionaDensidadSpan']").removeClass("a-btn-icon-right-sel");	
	transporteObj = new Object();
	transporteObjSol = new Object();
	listaBobinas = new Array();
	posBobina = 0;
	densidadParam = -1;
	$('#pesoestimado').html('');
	primerVehiculo=true;
	primerTipoSujecion=true;
	primerMaterial=true;
	setTimeout(function(){ 
		$('a[href$="tipoVehiculo"]').click();
		document.getElementById("calculo").scrollIntoView();
	}, 200);
	
	$(".thumb").removeClass("redimension");
	$(".a-btn-text").css("padding-top", paddingTop);
	$(".a-btn-text").css("font-size", fontSize);
	
	mostrarGraficos = true;
}

function generarExcel(){
	url = setUrlNoCache($.rup.CTX_PATH + "calculador/preparaDatos");
	$.ajax({
		url : url,
		type : "POST",
		data : JSON.stringify(transporteObjSol),
		contentType : "application/json",
		success : function(xhr, ajaxOptions) {
			//document.getElementById("generarReport").action = setUrlNoCache($.rup.CTX_PATH + "calculador/generarExcel");
			//document.getElementById("generarReport").submit();	
			var v = window.open(setUrlNoCache($.rup.CTX_PATH + "calculador/generarExcel?mostrarGraficos="+mostrarGraficos), "_blank","");
		},
		error : function(error) {
			desBloquearInterfaz();
		},
		beforeSend : function() {
			bloquearInterfaz();
		},
		complete : function() {	
			desBloquearInterfaz();
		}
	});
}

function generarHtml(){
	url = setUrlNoCache($.rup.CTX_PATH + "calculador/preparaDatos");
	$.ajax({
		url : url,
		type : "POST",
		data : JSON.stringify(transporteObjSol),
		contentType : "application/json",
		success : function(xhr, ajaxOptions) {
			var v = window.open(setUrlNoCache($.rup.CTX_PATH + "calculador/generarHtml?mostrarGraficos="+mostrarGraficos), "_blank","");
		},
		error : function(error) {
			desBloquearInterfaz();
		},
		beforeSend : function() {
			bloquearInterfaz();
		},
		complete : function() {	
			desBloquearInterfaz();
		}
	});
}

function generarPdf(){
	url = setUrlNoCache($.rup.CTX_PATH + "calculador/preparaDatos");
	$.ajax({
		url : url,
		type : "POST",
		data : JSON.stringify(transporteObjSol),
		contentType : "application/json",
		success : function(xhr, ajaxOptions) {
			//document.getElementById("generarReport").action = setUrlNoCache($.rup.CTX_PATH + "calculador/generarPdf");
			//document.getElementById("generarReport").submit();	
			window.open(setUrlNoCache($.rup.CTX_PATH + "calculador/generarPdf?mostrarGraficos="+mostrarGraficos), "_blank","");
		},
		error : function(error) {
			desBloquearInterfaz();
		},
		beforeSend : function() {
			bloquearInterfaz();
		},
		complete : function() {	
			desBloquearInterfaz();
		}
	});
}


//Bloquear pantalla mientras se esta realizando una operacion en segundo plano
//Permite asignarle propiedades
bloquearInterfaz = function(properties){
	var defaultProp = {
		baseZ: 999999,
		centerX: true, 
		css:{
			paddingTop: "1em",
			paddingBottom: "1em",
			color: "#ffffff",
			borderColor: "#222",
			background: "#444",
			fontSize : "1.6em",
			cursor:		'default'
		},
		overlayCSS: {
			backgroundColor: 	'#222222', 
			opacity:			0.3,
			cursor:		'default'
		}, 
		message : $.rup.i18n.base.rup_blockUI.cargando
	};
	$.blockUI($.extend(true, defaultProp, properties));
};

//Desbloquear pantalla
desBloquearInterfaz = function(){
	try{
		$.unblockUI();
	}catch(e){
		$('.blockUI').remove();
	}
};

redondearImporte = function(cantidad1, cantidad2){
	var resultado = parseFloat(cantidad1) / parseFloat(cantidad2);
	return Math.round((resultado) * 100) / 100;
};


//Cambio de sujecion de fleje a Bobina
function 	confirmarCambio(posNueva){
	$.rup_messages("msgConfirm", {
		message: $.rup.i18n.app.aa94a_mensajes.confirmacion,  
		title: $.rup.i18n.base.rup_message.confirmacion,
		OKFunction: function () {
			marcandoTSujecion(posNueva);
			$( "[id*='selDensidad']").removeClass("pulsado colorSeleccionado");
			$( "[id*='seleccionaDensidadSpan']").removeClass("a-btn-icon-right-sel");	
			transporteObj.tipoSujecion = new Object();
			transporteObj.tipoSujecion.codigo = posNueva ;
			$('#tablaBobinas tbody').html('');
			listaBobinas = new Array();
		
		
		}
	});
	
}